/*
 * Decompiled with CFR 0.152.
 */
package club.sk1er.mods.scrollabletooltips.elementa.impl.commonmark.internal;

import club.sk1er.mods.scrollabletooltips.elementa.impl.commonmark.internal.BlockContinueImpl;
import club.sk1er.mods.scrollabletooltips.elementa.impl.commonmark.internal.BlockQuoteParser;
import club.sk1er.mods.scrollabletooltips.elementa.impl.commonmark.internal.BlockStartImpl;
import club.sk1er.mods.scrollabletooltips.elementa.impl.commonmark.internal.DocumentBlockParser;
import club.sk1er.mods.scrollabletooltips.elementa.impl.commonmark.internal.FencedCodeBlockParser;
import club.sk1er.mods.scrollabletooltips.elementa.impl.commonmark.internal.HeadingParser;
import club.sk1er.mods.scrollabletooltips.elementa.impl.commonmark.internal.HtmlBlockParser;
import club.sk1er.mods.scrollabletooltips.elementa.impl.commonmark.internal.IndentedCodeBlockParser;
import club.sk1er.mods.scrollabletooltips.elementa.impl.commonmark.internal.InlineParserContextImpl;
import club.sk1er.mods.scrollabletooltips.elementa.impl.commonmark.internal.ListBlockParser;
import club.sk1er.mods.scrollabletooltips.elementa.impl.commonmark.internal.ParagraphParser;
import club.sk1er.mods.scrollabletooltips.elementa.impl.commonmark.internal.ThematicBreakParser;
import club.sk1er.mods.scrollabletooltips.elementa.impl.commonmark.internal.util.Parsing;
import club.sk1er.mods.scrollabletooltips.elementa.impl.commonmark.node.Block;
import club.sk1er.mods.scrollabletooltips.elementa.impl.commonmark.node.BlockQuote;
import club.sk1er.mods.scrollabletooltips.elementa.impl.commonmark.node.Document;
import club.sk1er.mods.scrollabletooltips.elementa.impl.commonmark.node.FencedCodeBlock;
import club.sk1er.mods.scrollabletooltips.elementa.impl.commonmark.node.Heading;
import club.sk1er.mods.scrollabletooltips.elementa.impl.commonmark.node.HtmlBlock;
import club.sk1er.mods.scrollabletooltips.elementa.impl.commonmark.node.IndentedCodeBlock;
import club.sk1er.mods.scrollabletooltips.elementa.impl.commonmark.node.LinkReferenceDefinition;
import club.sk1er.mods.scrollabletooltips.elementa.impl.commonmark.node.ListBlock;
import club.sk1er.mods.scrollabletooltips.elementa.impl.commonmark.node.Paragraph;
import club.sk1er.mods.scrollabletooltips.elementa.impl.commonmark.node.SourceSpan;
import club.sk1er.mods.scrollabletooltips.elementa.impl.commonmark.node.ThematicBreak;
import club.sk1er.mods.scrollabletooltips.elementa.impl.commonmark.parser.IncludeSourceSpans;
import club.sk1er.mods.scrollabletooltips.elementa.impl.commonmark.parser.InlineParser;
import club.sk1er.mods.scrollabletooltips.elementa.impl.commonmark.parser.InlineParserFactory;
import club.sk1er.mods.scrollabletooltips.elementa.impl.commonmark.parser.SourceLine;
import club.sk1er.mods.scrollabletooltips.elementa.impl.commonmark.parser.SourceLines;
import club.sk1er.mods.scrollabletooltips.elementa.impl.commonmark.parser.block.AbstractBlockParserFactory;
import club.sk1er.mods.scrollabletooltips.elementa.impl.commonmark.parser.block.BlockContinue;
import club.sk1er.mods.scrollabletooltips.elementa.impl.commonmark.parser.block.BlockParser;
import club.sk1er.mods.scrollabletooltips.elementa.impl.commonmark.parser.block.BlockParserFactory;
import club.sk1er.mods.scrollabletooltips.elementa.impl.commonmark.parser.block.BlockStart;
import club.sk1er.mods.scrollabletooltips.elementa.impl.commonmark.parser.block.MatchedBlockParser;
import club.sk1er.mods.scrollabletooltips.elementa.impl.commonmark.parser.block.ParserState;
import club.sk1er.mods.scrollabletooltips.elementa.impl.commonmark.parser.delimiter.DelimiterProcessor;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DocumentParser
implements ParserState {
    private static final Set<Class<? extends Block>> CORE_FACTORY_TYPES = new LinkedHashSet<Class>(Arrays.asList(BlockQuote.class, Heading.class, FencedCodeBlock.class, HtmlBlock.class, ThematicBreak.class, ListBlock.class, IndentedCodeBlock.class));
    private static final Map<Class<? extends Block>, BlockParserFactory> NODES_TO_CORE_FACTORIES;
    private SourceLine line;
    private int lineIndex = -1;
    private int index = 0;
    private int column = 0;
    private boolean columnIsInTab;
    private int nextNonSpace = 0;
    private int nextNonSpaceColumn = 0;
    private int indent = 0;
    private boolean blank;
    private final List<BlockParserFactory> blockParserFactories;
    private final InlineParserFactory inlineParserFactory;
    private final List<DelimiterProcessor> delimiterProcessors;
    private final IncludeSourceSpans includeSourceSpans;
    private final DocumentBlockParser documentBlockParser;
    private final Map<String, LinkReferenceDefinition> definitions = new LinkedHashMap<String, LinkReferenceDefinition>();
    private final List<OpenBlockParser> openBlockParsers = new ArrayList<OpenBlockParser>();
    private final List<BlockParser> allBlockParsers = new ArrayList<BlockParser>();

    public DocumentParser(List<BlockParserFactory> blockParserFactories, InlineParserFactory inlineParserFactory, List<DelimiterProcessor> delimiterProcessors, IncludeSourceSpans includeSourceSpans) {
        this.blockParserFactories = blockParserFactories;
        this.inlineParserFactory = inlineParserFactory;
        this.delimiterProcessors = delimiterProcessors;
        this.includeSourceSpans = includeSourceSpans;
        this.documentBlockParser = new DocumentBlockParser();
        this.activateBlockParser(new OpenBlockParser(this.documentBlockParser, 0));
    }

    public static Set<Class<? extends Block>> getDefaultBlockParserTypes() {
        return CORE_FACTORY_TYPES;
    }

    public static List<BlockParserFactory> calculateBlockParserFactories(List<BlockParserFactory> customBlockParserFactories, Set<Class<? extends Block>> enabledBlockTypes) {
        ArrayList<BlockParserFactory> list = new ArrayList<BlockParserFactory>();
        list.addAll(customBlockParserFactories);
        for (Class<? extends Block> blockType : enabledBlockTypes) {
            list.add(NODES_TO_CORE_FACTORIES.get(blockType));
        }
        return list;
    }

    public Document parse(String input) {
        String line;
        int lineBreak;
        int lineStart = 0;
        while ((lineBreak = Parsing.findLineBreak(input, lineStart)) != -1) {
            line = input.substring(lineStart, lineBreak);
            this.parseLine(line);
            if (lineBreak + 1 < input.length() && input.charAt(lineBreak) == '\r' && input.charAt(lineBreak + 1) == '\n') {
                lineStart = lineBreak + 2;
                continue;
            }
            lineStart = lineBreak + 1;
        }
        if (input.length() > 0 && (lineStart == 0 || lineStart < input.length())) {
            line = input.substring(lineStart);
            this.parseLine(line);
        }
        return this.finalizeAndProcess();
    }

    public Document parse(Reader input) throws IOException {
        String line;
        BufferedReader bufferedReader = input instanceof BufferedReader ? (BufferedReader)input : new BufferedReader(input);
        while ((line = bufferedReader.readLine()) != null) {
            this.parseLine(line);
        }
        return this.finalizeAndProcess();
    }

    @Override
    public SourceLine getLine() {
        return this.line;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public int getNextNonSpaceIndex() {
        return this.nextNonSpace;
    }

    @Override
    public int getColumn() {
        return this.column;
    }

    @Override
    public int getIndent() {
        return this.indent;
    }

    @Override
    public boolean isBlank() {
        return this.blank;
    }

    @Override
    public BlockParser getActiveBlockParser() {
        return this.openBlockParsers.get(this.openBlockParsers.size() - 1).blockParser;
    }

    private void parseLine(CharSequence ln) {
        boolean tryBlockStarts;
        this.setLine(ln);
        int matches = 1;
        for (int i2 = 1; i2 < this.openBlockParsers.size(); ++i2) {
            OpenBlockParser openBlockParser = this.openBlockParsers.get(i2);
            BlockParser blockParser = openBlockParser.blockParser;
            this.findNextNonSpace();
            BlockContinue result = blockParser.tryContinue(this);
            if (!(result instanceof BlockContinueImpl)) break;
            BlockContinueImpl blockContinue = (BlockContinueImpl)result;
            openBlockParser.sourceIndex = this.getIndex();
            if (blockContinue.isFinalize()) {
                this.addSourceSpans();
                this.closeBlockParsers(this.openBlockParsers.size() - i2);
                return;
            }
            if (blockContinue.getNewIndex() != -1) {
                this.setNewIndex(blockContinue.getNewIndex());
            } else if (blockContinue.getNewColumn() != -1) {
                this.setNewColumn(blockContinue.getNewColumn());
            }
            ++matches;
        }
        int unmatchedBlocks = this.openBlockParsers.size() - matches;
        BlockParser blockParser = this.openBlockParsers.get(matches - 1).blockParser;
        boolean startedNewBlock = false;
        int lastIndex = this.index;
        boolean bl = tryBlockStarts = blockParser.getBlock() instanceof Paragraph || blockParser.isContainer();
        while (tryBlockStarts) {
            lastIndex = this.index;
            this.findNextNonSpace();
            if (this.isBlank() || this.indent < Parsing.CODE_BLOCK_INDENT && Parsing.isLetter(this.line.getContent(), this.nextNonSpace)) {
                this.setNewIndex(this.nextNonSpace);
                break;
            }
            BlockStartImpl blockStart = this.findBlockStart(blockParser);
            if (blockStart == null) {
                this.setNewIndex(this.nextNonSpace);
                break;
            }
            startedNewBlock = true;
            int sourceIndex = this.getIndex();
            if (unmatchedBlocks > 0) {
                this.closeBlockParsers(unmatchedBlocks);
                unmatchedBlocks = 0;
            }
            if (blockStart.getNewIndex() != -1) {
                this.setNewIndex(blockStart.getNewIndex());
            } else if (blockStart.getNewColumn() != -1) {
                this.setNewColumn(blockStart.getNewColumn());
            }
            List<SourceSpan> replacedSourceSpans = null;
            if (blockStart.isReplaceActiveBlockParser()) {
                Block replacedBlock = this.prepareActiveBlockParserForReplacement();
                replacedSourceSpans = replacedBlock.getSourceSpans();
            }
            for (BlockParser newBlockParser : blockStart.getBlockParsers()) {
                this.addChild(new OpenBlockParser(newBlockParser, sourceIndex));
                if (replacedSourceSpans != null) {
                    newBlockParser.getBlock().setSourceSpans(replacedSourceSpans);
                }
                blockParser = newBlockParser;
                tryBlockStarts = newBlockParser.isContainer();
            }
        }
        if (!startedNewBlock && !this.isBlank() && this.getActiveBlockParser().canHaveLazyContinuationLines()) {
            this.openBlockParsers.get(this.openBlockParsers.size() - 1).sourceIndex = lastIndex;
            this.addLine();
        } else {
            if (unmatchedBlocks > 0) {
                this.closeBlockParsers(unmatchedBlocks);
            }
            if (!blockParser.isContainer()) {
                this.addLine();
            } else if (!this.isBlank()) {
                ParagraphParser paragraphParser = new ParagraphParser();
                this.addChild(new OpenBlockParser(paragraphParser, lastIndex));
                this.addLine();
            } else {
                this.addSourceSpans();
            }
        }
    }

    private void setLine(CharSequence ln) {
        ++this.lineIndex;
        this.index = 0;
        this.column = 0;
        this.columnIsInTab = false;
        CharSequence lineContent = Parsing.prepareLine(ln);
        SourceSpan sourceSpan = null;
        if (this.includeSourceSpans != IncludeSourceSpans.NONE) {
            sourceSpan = SourceSpan.of(this.lineIndex, 0, lineContent.length());
        }
        this.line = SourceLine.of(lineContent, sourceSpan);
    }

    private void findNextNonSpace() {
        int i2 = this.index;
        int cols = this.column;
        this.blank = true;
        int length = this.line.getContent().length();
        block4: while (i2 < length) {
            char c = this.line.getContent().charAt(i2);
            switch (c) {
                case ' ': {
                    ++i2;
                    ++cols;
                    continue block4;
                }
                case '\t': {
                    ++i2;
                    cols += 4 - cols % 4;
                    continue block4;
                }
            }
            this.blank = false;
            break;
        }
        this.nextNonSpace = i2;
        this.nextNonSpaceColumn = cols;
        this.indent = this.nextNonSpaceColumn - this.column;
    }

    private void setNewIndex(int newIndex) {
        if (newIndex >= this.nextNonSpace) {
            this.index = this.nextNonSpace;
            this.column = this.nextNonSpaceColumn;
        }
        int length = this.line.getContent().length();
        while (this.index < newIndex && this.index != length) {
            this.advance();
        }
        this.columnIsInTab = false;
    }

    private void setNewColumn(int newColumn) {
        if (newColumn >= this.nextNonSpaceColumn) {
            this.index = this.nextNonSpace;
            this.column = this.nextNonSpaceColumn;
        }
        int length = this.line.getContent().length();
        while (this.column < newColumn && this.index != length) {
            this.advance();
        }
        if (this.column > newColumn) {
            --this.index;
            this.column = newColumn;
            this.columnIsInTab = true;
        } else {
            this.columnIsInTab = false;
        }
    }

    private void advance() {
        char c = this.line.getContent().charAt(this.index);
        ++this.index;
        this.column = c == '\t' ? (this.column += Parsing.columnsToNextTabStop(this.column)) : ++this.column;
    }

    private void addLine() {
        CharSequence content;
        if (this.columnIsInTab) {
            int afterTab = this.index + 1;
            CharSequence rest = this.line.getContent().subSequence(afterTab, this.line.getContent().length());
            int spaces = Parsing.columnsToNextTabStop(this.column);
            StringBuilder sb = new StringBuilder(spaces + rest.length());
            for (int i2 = 0; i2 < spaces; ++i2) {
                sb.append(' ');
            }
            sb.append(rest);
            content = sb.toString();
        } else {
            content = this.index == 0 ? this.line.getContent() : this.line.getContent().subSequence(this.index, this.line.getContent().length());
        }
        SourceSpan sourceSpan = null;
        if (this.includeSourceSpans == IncludeSourceSpans.BLOCKS_AND_INLINES) {
            sourceSpan = SourceSpan.of(this.lineIndex, this.index, content.length());
        }
        this.getActiveBlockParser().addLine(SourceLine.of(content, sourceSpan));
        this.addSourceSpans();
    }

    private void addSourceSpans() {
        if (this.includeSourceSpans != IncludeSourceSpans.NONE) {
            for (int i2 = 1; i2 < this.openBlockParsers.size(); ++i2) {
                OpenBlockParser openBlockParser = this.openBlockParsers.get(i2);
                int blockIndex = openBlockParser.sourceIndex;
                int length = this.line.getContent().length() - blockIndex;
                if (length == 0) continue;
                openBlockParser.blockParser.addSourceSpan(SourceSpan.of(this.lineIndex, blockIndex, length));
            }
        }
    }

    private BlockStartImpl findBlockStart(BlockParser blockParser) {
        MatchedBlockParserImpl matchedBlockParser = new MatchedBlockParserImpl(blockParser);
        for (BlockParserFactory blockParserFactory : this.blockParserFactories) {
            BlockStart result = blockParserFactory.tryStart(this, matchedBlockParser);
            if (!(result instanceof BlockStartImpl)) continue;
            return (BlockStartImpl)result;
        }
        return null;
    }

    private void finalize(BlockParser blockParser) {
        if (blockParser instanceof ParagraphParser) {
            this.addDefinitionsFrom((ParagraphParser)blockParser);
        }
        blockParser.closeBlock();
    }

    private void addDefinitionsFrom(ParagraphParser paragraphParser) {
        for (LinkReferenceDefinition definition : paragraphParser.getDefinitions()) {
            paragraphParser.getBlock().insertBefore(definition);
            String label = definition.getLabel();
            if (this.definitions.containsKey(label)) continue;
            this.definitions.put(label, definition);
        }
    }

    private void processInlines() {
        InlineParserContextImpl context = new InlineParserContextImpl(this.delimiterProcessors, this.definitions);
        InlineParser inlineParser = this.inlineParserFactory.create(context);
        for (BlockParser blockParser : this.allBlockParsers) {
            blockParser.parseInlines(inlineParser);
        }
    }

    private void addChild(OpenBlockParser openBlockParser) {
        while (!this.getActiveBlockParser().canContain(openBlockParser.blockParser.getBlock())) {
            this.closeBlockParsers(1);
        }
        this.getActiveBlockParser().getBlock().appendChild(openBlockParser.blockParser.getBlock());
        this.activateBlockParser(openBlockParser);
    }

    private void activateBlockParser(OpenBlockParser openBlockParser) {
        this.openBlockParsers.add(openBlockParser);
    }

    private OpenBlockParser deactivateBlockParser() {
        return this.openBlockParsers.remove(this.openBlockParsers.size() - 1);
    }

    private Block prepareActiveBlockParserForReplacement() {
        BlockParser old = this.deactivateBlockParser().blockParser;
        if (old instanceof ParagraphParser) {
            ParagraphParser paragraphParser = (ParagraphParser)old;
            this.addDefinitionsFrom(paragraphParser);
        }
        old.closeBlock();
        old.getBlock().unlink();
        return old.getBlock();
    }

    private Document finalizeAndProcess() {
        this.closeBlockParsers(this.openBlockParsers.size());
        this.processInlines();
        return this.documentBlockParser.getBlock();
    }

    private void closeBlockParsers(int count) {
        for (int i2 = 0; i2 < count; ++i2) {
            BlockParser blockParser = this.deactivateBlockParser().blockParser;
            this.finalize(blockParser);
            this.allBlockParsers.add(blockParser);
        }
    }

    static {
        HashMap<Class<IndentedCodeBlock>, AbstractBlockParserFactory> map2 = new HashMap<Class<IndentedCodeBlock>, AbstractBlockParserFactory>();
        map2.put(BlockQuote.class, new BlockQuoteParser.Factory());
        map2.put(Heading.class, new HeadingParser.Factory());
        map2.put(FencedCodeBlock.class, new FencedCodeBlockParser.Factory());
        map2.put(HtmlBlock.class, new HtmlBlockParser.Factory());
        map2.put(ThematicBreak.class, new ThematicBreakParser.Factory());
        map2.put(ListBlock.class, new ListBlockParser.Factory());
        map2.put(IndentedCodeBlock.class, new IndentedCodeBlockParser.Factory());
        NODES_TO_CORE_FACTORIES = Collections.unmodifiableMap(map2);
    }

    private static class OpenBlockParser {
        private final BlockParser blockParser;
        private int sourceIndex;

        OpenBlockParser(BlockParser blockParser, int sourceIndex) {
            this.blockParser = blockParser;
            this.sourceIndex = sourceIndex;
        }
    }

    private static class MatchedBlockParserImpl
    implements MatchedBlockParser {
        private final BlockParser matchedBlockParser;

        public MatchedBlockParserImpl(BlockParser matchedBlockParser) {
            this.matchedBlockParser = matchedBlockParser;
        }

        @Override
        public BlockParser getMatchedBlockParser() {
            return this.matchedBlockParser;
        }

        @Override
        public SourceLines getParagraphLines() {
            if (this.matchedBlockParser instanceof ParagraphParser) {
                ParagraphParser paragraphParser = (ParagraphParser)this.matchedBlockParser;
                return paragraphParser.getParagraphLines();
            }
            return SourceLines.empty();
        }
    }
}

